<?php
require_once __DIR__ . '/../config/db.php';

try {
    // Add serial_numbers column to refund_items table if it doesn't exist
    $pdo->exec("ALTER TABLE refund_items ADD COLUMN IF NOT EXISTS `serial_numbers` TEXT NULL COMMENT 'JSON array of serial numbers returned to stock'");
    echo "Added serial_numbers column to refund_items table successfully.\n";
    
    // Check if the column was added
    $stmt = $pdo->query("DESCRIBE refund_items");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $hasSerialNumbers = false;
    foreach ($columns as $column) {
        if ($column['Field'] === 'serial_numbers') {
            $hasSerialNumbers = true;
            break;
        }
    }
    
    if ($hasSerialNumbers) {
        echo "Serial numbers column is ready for use.\n";
    } else {
        echo "Failed to add serial numbers column.\n";
    }
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
} 